Lattice {
	// MODEL:
	var <>lsize; // size of the lattice dimensions, Array(dimensions)>> [size1, size2, size3] for 3d
	var <>dimension;
	var <>data; // data array
	
	*new { |inlsize=30| ^super.new.init(inlsize) }

	init {arg inlsize;  
	
	lsize = inlsize;
	dimension = lsize.size;
	
	}

    
    	randData { |fac = 1.0|
		data = Array.fillND(lsize, { fac.rand }); 
		^data; 
	}

	randDataOnLinks { |fac = 1.0|
		var lsizeL = lsize.add(lsize.size);
		data = Array.fillND(lsizeL, { fac.rand }); 
		^data; 
	}	

	neighborsVals { |x, near=1|
		var nearestN, next2nearestN, neighborsInM, neighborsInds;
		
//		neighborsInds = this.neighborsInds(x, near);
//		neighborsInM = Array.fill2D(neighborsInds.size, neighborsInds[0].size);
//		neighborsInds.do{|item, i|
//			item.do
//			neighborsInM[i] = data.wrapAt(item[0]).wrapAt(item[1]).wrapAt(item[2]).wrapAt(item[3])
//		}
		
		if (dimension == 4)
		{
			nearestN = [
			 // next neighbours
					data.wrapAt(x[0]-1)[x[1]][x[2]][x[3]], 
					data.wrapAt(x[0]+1)[x[1]][x[2]][x[3]],
					data[x[0]].wrapAt(x[1]+1)[x[2]][x[3]],
					data[x[0]].wrapAt(x[1]-1)[x[2]][x[3]], 
					data[x[0]][x[1]].wrapAt(x[2]+1)[x[3]],
					data[x[0]][x[1]].wrapAt(x[2]-1)[x[3]], 
					data[x[0]][x[1]][x[2]].wrapAt(x[3]-1), 
					data[x[0]][x[1]][x[2]].wrapAt(x[3]+1)
			];		
			next2nearestN = 
				[ // next to next neighbours
				// c d
					data.wrapAt(x[0]+1).wrapAt(x[1]+1)[x[2]][x[3]], 
					data.wrapAt(x[0]+1).wrapAt(x[1]-1)[x[2]][x[3]], 
					data.wrapAt(x[0]-1).wrapAt(x[1]+1)[x[2]][x[3]],
					data.wrapAt(x[0]-1).wrapAt(x[1]-1)[x[2]][x[3]],
				// b d
					data.wrapAt(x[0]+1)[x[1]].wrapAt(x[2]+1)[x[3]], 
					data.wrapAt(x[0]+1)[x[1]].wrapAt(x[2]-1)[x[3]], 
					data.wrapAt(x[0]-1)[x[1]].wrapAt(x[2]+1)[x[3]],
					data.wrapAt(x[0]-1)[x[1]].wrapAt(x[2]-1)[x[3]],
				// b c
					data.wrapAt(x[0]+1)[x[1]][x[2]].wrapAt(x[3]+1), 
					data.wrapAt(x[0]+1)[x[1]][x[2]].wrapAt(x[3]-1), 
					data.wrapAt(x[0]-1)[x[1]][x[2]].wrapAt(x[3]+1),
					data.wrapAt(x[0]-1)[x[1]][x[2]].wrapAt(x[3]-1),
				// a d
					data[x[0]].wrapAt(x[1]+1).wrapAt(x[2]+1)[x[3]],
					data[x[0]].wrapAt(x[1]+1).wrapAt(x[2]-1)[x[3]],
					data[x[0]].wrapAt(x[1]-1).wrapAt(x[2]+1)[x[3]],
					data[x[0]].wrapAt(x[1]-1).wrapAt(x[2]-1)[x[3]],
				// a b
					data[x[0]][x[1]].wrapAt(x[2]+1).wrapAt(x[3]+1),
					data[x[0]][x[1]].wrapAt(x[2]+1).wrapAt(x[3]-1),
					data[x[0]][x[1]].wrapAt(x[2]-1).wrapAt(x[3]+1),
					data[x[0]][x[1]].wrapAt(x[2]-1).wrapAt(x[3]-1),
				// a c
					data[x[0]].wrapAt(x[1]+1)[x[2]].wrapAt(x[3]+1),
					data[x[0]].wrapAt(x[1]+1)[x[2]].wrapAt(x[3]-1),
					data[x[0]].wrapAt(x[1]-1)[x[2]].wrapAt(x[3]+1),
					data[x[0]].wrapAt(x[1]-1)[x[2]].wrapAt(x[3]-1)
			];
		} {"not implemented for this dimension!".postln};
		if (near == 0) {neighborsInM = nearestN};
		if (near == 1) {neighborsInM = nearestN ++ next2nearestN};
		^neighborsInM
	}


	neighborsInds { |x, near=1|
		var nearestN, next2nearestN, neighborsInM;
		var indN = 0, indN2 = 0;

		nearestN = Array.fill(2*dimension, {|i| Array.fill(dimension, {|j| x[j]}) });
		dimension.do {|i|
			nearestN[indN][i] = (x[i] - 1).mod(lsize[i]);
			indN = indN + 1;
			nearestN[indN][i] = (x[i] + 1).mod(lsize[i]);
			indN = indN + 1;
		};

// NOCH NICHT FERTIGGESCHRIEBEN fuer allg. dimensions:	
//		next2nearestN = Array.fill(2*(dimension-1)*dimension, {|i| Array.fill(dimension, {|j| x[j]}) });
//		dimension.do {|i|
//			next2nearestN[indN][i] = (x[i] - 1).mod(lsize[i]);
//			indN = indN + 1;
//			next2nearestN[indN][i] = (x[i] + 1).mod(lsize[i]);
//			indN = indN + 1;
//		};
		if (near == 1 and:{dimension==4})
		{
			next2nearestN = 
				[ // next to next neighbours
				// c d
					[(x[0]+1).mod(lsize[0]), (x[1]+1).mod(lsize[1]), x[2], x[3]], 
					[(x[0]+1).mod(lsize[0]), (x[1]-1).mod(lsize[1]), x[2], x[3]], 
					[(x[0]-1).mod(lsize[0]), (x[1]+1).mod(lsize[1]), x[2], x[3]], 
					[(x[0]-1).mod(lsize[0]), (x[1]-1).mod(lsize[1]), x[2], x[3]], 
				// b d
					[(x[0]+1).mod(lsize[0]), x[1], (x[2]+1).mod(lsize[2]), x[3]], 
					[(x[0]+1).mod(lsize[0]), x[1], (x[2]-1).mod(lsize[2]), x[3]], 
					[(x[0]-1).mod(lsize[0]), x[1], (x[2]+1).mod(lsize[2]), x[3]], 
					[(x[0]-1).mod(lsize[0]), x[1], (x[2]-1).mod(lsize[2]), x[3]], 
				// b c
					[(x[0]+1).mod(lsize[0]), x[1], x[2], (x[3]+1).mod(lsize[3])], 
					[(x[0]+1).mod(lsize[0]), x[1], x[2], (x[3]-1).mod(lsize[3])], 
					[(x[0]-1).mod(lsize[0]), x[1], x[2], (x[3]+1).mod(lsize[3])], 
					[(x[0]-1).mod(lsize[0]), x[1], x[2], (x[3]-1).mod(lsize[3])], 
				// a d
					[x[0], (x[1]+1).mod(lsize[1]), (x[2]+1).mod(lsize[2]), x[3]],
					[x[0], (x[1]+1).mod(lsize[1]), (x[2]-1).mod(lsize[2]), x[3]],
					[x[0], (x[1]-1).mod(lsize[1]), (x[2]+1).mod(lsize[2]), x[3]],
					[x[0], (x[1]-1).mod(lsize[1]), (x[2]-1).mod(lsize[2]), x[3]],
				// a b
					[x[0], x[1], (x[2]+1).mod(lsize[2]), (x[3]+1).mod(lsize[3])],
					[x[0], x[1], (x[2]+1).mod(lsize[2]), (x[3]-1).mod(lsize[3])],
					[x[0], x[1], (x[2]-1).mod(lsize[2]), (x[3]+1).mod(lsize[3])],
					[x[0], x[1], (x[2]-1).mod(lsize[2]), (x[3]-1).mod(lsize[3])],
				// a c
					[x[0], (x[1]+1).mod(lsize[1]), x[2], (x[3]+1).mod(lsize[3])],
					[x[0], (x[1]+1).mod(lsize[1]), x[2], (x[3]-1).mod(lsize[3])],
					[x[0], (x[1]-1).mod(lsize[1]), x[2], (x[3]+1).mod(lsize[3])],
					[x[0], (x[1]-1).mod(lsize[1]), x[2], (x[3]-1).mod(lsize[3])],
			];
		};
		if (near == 1 and:{dimension!=4}) { "Next to next neighbours only work with 4 dimensions until now!".postln };
		if (near == 0) {neighborsInM = nearestN};
		if (near == 1) {neighborsInM = nearestN ++ next2nearestN};
		^neighborsInM
	}


    	// find neighbours of distance n (star-shaped) around an index i,j of data:
	surround {|n = 2, i=0, j=0| // n.. order of neighbours
		var surr;
		var x1, x2, x3, x4, y1, y2, y3, y4;
		(1..n).do{|m|
			if((n-m) == 0)
			{
			x1 = (i+(n-m)).mod(lsize[0]); y1 = (j+m).mod(lsize[1]);
			x2 = (i+(n-m)).mod(lsize[0]); y2 = (j-m).mod(lsize[1]);
			x3 = (i-m).mod(lsize[0]); y3 = (j-(n-m)).mod(lsize[1]);
			x4 = (i+m).mod(lsize[0]); y4 = (j-(n-m)).mod(lsize[1]);
			surr = surr ++ [[x1, y1], [x3, y3], [x2, y2], [x4, y4]];
				}
			{
			x1 = (i+(n-m)).mod(lsize[0]); y1 = (j+m).mod(lsize[1]);
			x2 = (i+(n-m)).mod(lsize[0]); y2 = (j-m).mod(lsize[1]);
			x3 = (i-(n-m)).mod(lsize[0]); y3 = (j-m).mod(lsize[1]);
			x4 = (i-(n-m)).mod(lsize[0]); y4 = (j+m).mod(lsize[1]);
			surr = surr ++ [[x4, y4], [x3, y3], [x2, y2], [x1, y1]];
			};
		};
	^surr
	}
	

	quarters {|i, j|
		var thisquarter;
		thisquarter = [
			[i,					     j			        ],
			[ i, 				     (j + 1).mod(lsize[1]) ],
			[ (i + 1).mod(lsize[0]), 	(j + 1).mod(lsize[1]) ],
			[ (i + 1).mod(lsize[0]), 	 j	                  ]
		];
		^thisquarter
	}
	
	triangs {|i, j, whichT|
		var thistriangs;
		if (whichT == 0) 
			{thistriangs = [[i,	j], [ i, (j + 1).mod(lsize[1])],[ (i + 1).mod(lsize[0]), j]]};
		if (whichT == 1) 
			{thistriangs = [[i,	j], [ i, (j + 1).mod(lsize[1])],[ (i + 1).mod(lsize[0]), (j + 1).mod(lsize[1])]]};
		if (whichT == 2) 
			{thistriangs = [[i,	j], [ (i + 1).mod(lsize[0]), (j + 1).mod(lsize[1])], [ (i+1).mod(lsize[0]), j]]};
		if (whichT == 3) 
			{thistriangs = [[i,	(j + 1).mod(lsize[1])],[ (i + 1).mod(lsize[0]), (j + 1).mod(lsize[1])], [ (i + 1).mod(lsize[0]), j]]};
		^thistriangs;
	}
	
	
	makeSpiral {|order=5, startx=0, starty=0|
		var count, spiral, directions;
		count = 0;
		directions = [[1, 0], [0, -1], [-1, 0], [0, 1]];
		spiral = [[startx, starty]];
	
		order.do{|i|
			if(i<(order-1))
				{ (i+2).do{|in| spiral = spiral ++ [spiral.last+(directions.wrapAt(count))]}; count = count + 1;}
				{ spiral = spiral ++ [spiral.last+(directions.wrapAt(count))];count = count + 1;}
		};
		spiral = spiral ++ [spiral.last+(directions.wrapAt(count)*(1))];
		count = count + 2;
		order.do{|i|			
			(order - (i+2)).do{|in| 
				spiral = spiral ++ [spiral.last-(directions.wrapAt(count))]
				};
			count = count - 1;
		};
		count = count - 2;
		spiral = spiral ++ [spiral.last-(directions.wrapAt(count))];
		count = count - 1;
		spiral = spiral ++ [spiral.last+(directions.wrapAt(count))];
		spiral = spiral.mod(lsize[0]);
	^spiral
	}

	relAnglDiff {|m, n|
		var diff, x;
		diff = m - n;
		if( (diff.abs) > pi )
			{ 
			if (diff > 0)
				{x = ((2pi - diff).mod(2pi));}
				{x = ((2pi - diff).neg.mod(2pi).neg);}
			}
			{ x = (diff).neg;};
		^x
	}
	

	
//	findPM2pi {|whichSpins='quarter'|
//		var numbP2pi = 0, placeP2pi = [], numbM2pi = 0, placeM2pi = [], ntimes;
//			data.do{|lines, i|
//				lines.do{|spins, j|
//					if (whichSpins == 'triang') {ntimes = 4} {ntimes = 1};
//					ntimes.do{|tind|
//						var whichvecs, whichsum = 0;
//
//						if (whichSpins == 'quarter')
//							{ this.quarters(i,j).do{|k| whichvecs = whichvecs ++ [data[k[0]][k[1]]];
//							}}; 
//						if (whichSpins == 'triang')
//							{ this.triangs(i,j,tind).do{|k| whichvecs = whichvecs ++ [data[k[0]][k[1]]]}};
//						if (whichSpins == 'spirale')
//							{this.makeSpiral(spiraleOrder, i, j).do{|k| whichvecs = whichvecs ++ [data[k[0]][k[1]]]}};
//
//						whichvecs.do{|l, ind| 
//							var diff = this.relAnglDiff((whichvecs[(ind+1).mod(whichvecs.size)]), whichvecs[ind]);
//							whichsum = whichsum + diff;
//						};
//
//						if ((whichsum.round(0.000001)) == (2pi.round(0.000001)) ) 
//						{numbP2pi = numbP2pi + 1; placeP2pi = placeP2pi ++ [[i, j]];};
//						if ((whichsum.round(0.000001)) == (-2pi.round(0.000001)) ) 
//						{numbM2pi = numbM2pi + 1; placeM2pi = placeM2pi ++ [[i, j]];};
//					}
//				}
//			};
//		^[numbP2pi, placeP2pi, numbM2pi, placeM2pi]; 
//
//	}

	
	findDupLists {|listA, listB|
		var clones = [], singles = [];
		listA.do{ |itemA|
			if(listB.find([itemA]).notNil) 
				{clones = clones ++ [itemA]} {singles = singles ++ [itemA]}
		};
	^[singles.size, "singles", singles, clones.size, "clones", clones];
	}
	
	// do a  transformation of factor 2 and give back the new data:
	blockspinT {
		var rowInd = -1, colInd = -1, newsize = lsize[0]/2;
		var nextNeighs, next2nextNeighs, dataBlocked = Array.fill2D(newsize, newsize, 0);
		
		data.do{|rows, j|
			if (j.odd) {colInd = colInd + 1};
			rowInd = -1;
			rows.do{|spins, i|
				var nextNeighsSum = 0, next2nextNeighsSum = 0;
				if (i.odd) {rowInd = rowInd + 1};
				if (j.odd and:{i.odd})
					{
						nextNeighs = this.surround(1,i,j); // next neighbours
						nextNeighs.do{|n| 
							nextNeighsSum = nextNeighsSum + data[n[0]][n[1]]
						};
						next2nextNeighs = this.surround(2,i,j)[0..3]; // next to next neighbours
						next2nextNeighs.do{|n| 
							next2nextNeighsSum = next2nextNeighsSum + data[n[0]][n[1]]
						};			
						dataBlocked[rowInd][colInd] = 
						((0.5 * data[i][j]) + ( (1/3) * (nextNeighsSum) ) + ( (1/6) * (next2nextNeighsSum) ) );
					}
					{};
			}
		};
	^dataBlocked;
	}
	
	normalizeIfNes { |testIfNes = true|			
		var index=0, origData, normData;
		var flatData = data.flat;
		var nes;
		if ( flatData.maxItem>1 or:{flatData.minItem<0} ) {nes = 1} {nes = 0};
		if ( testIfNes == true and:{ nes==1 } or:{testIfNes == false}) 
			{ 
			// normalize the data
			normData = data.deepCopy;
			origData = flatData.normalize(0,1);
			normData.do{|dim1, d1| 
				dim1.do{|dim2, d2| 
					dim2.do{|dim3, d3| 
						dim3.do{|dim4, d4| 
							normData[d1][d2][d3][d4] = origData[index]; index = index + 1;
						}
					}
				}
			};
			data = normData;
			}
	}

	
	pathFollow { |numb=100, which='simile', rand=0.0, postIt=false|
		var x, y, z, t, path;
		var site, neighborInds, neighborVals, index, inertW = Array.fill(4);
		var where, randN;
		
		x = lsize[0].rand; y = lsize[1].rand; z = lsize[2].rand; t = lsize[3].rand;
		randN = 1.0.rand;
		path = Array.fill2D(numb+1, 3, 0);
		path[0] = [data[x][y][z][t], [x, y, z, t]];

		(numb-1).do{|i|
			x = path[i][1][0]; y = path[i][1][1]; z = path[i][1][2]; t = path[i][1][3];
			if(postIt == true) {[path[i]].postln};
			neighborInds = this.neighborsInds(x, y, z, t);
			neighborVals = this.neighborsVals(x, y, z, t);

		if (which == 'simile')
			{
				var whereDiff = Array.fill(4), thisDiff, thisWay, inertW = Array.fill(4, 0), thereDiff, newInd;
				where = Array.fill(32, {|wi| (neighborVals[wi] - path[i][0]).abs }).minIndex;
				
//				[\site, path[i][0],\at, path[i][1], \closestN, neighborVals[where], \at, neighborInds[where]].postln;
				
				if (i<5) 
					{ path[(i+1)] = [neighborVals[where], neighborInds[where]] } // start path
					{ // continue with weighted "inertia" movement
					4.do{|k|
						thisDiff = ((path[(i-(3-k))][1] - path[(i-(4-k))][1])).sign; // difference between neighbours can only be +/-1!
						inertW = inertW + (thisDiff * ((k+1)/20));
//						[\k, k, \this, path[(i-(3-k))][1], \at, i-(3-k), \minus, path[(i-(4-k))][1], \at, i-(4-k), \is, thisDiff, inertW].postln;
					};
					thisDiff = (neighborInds[where] - path[i][1]).sign;
					inertW = inertW + (thisDiff * (1/2));
//					[\where, neighborInds[where], \is, path[i][1], \diff, thisDiff, \at, thereDiff, \newInertia, inertW].postln;
					};
					newInd = (neighborInds[where]+inertW).round(1);
					path[(i+1)] = [data[newInd[0]][newInd[1]][newInd[2]][newInd[3]], newInd ]; 
//					[\ENDSITE, path[(i+1)]].postln;


			}
		}
//		if (which == 'rising')
//			{}
//		if (which == 'falling')
//			{}
	}


}	
