// change Lattice class to 3 plus 1 dimensions

Lattice3p1 : Lattice {
	var <>aCoord, <>bCoord, <>cCoord, <>dCoord;
	var aziGUI, elevGUI;

	var <>coupling; // coupling variable
	var <> epsilon; // max. range of change of new randomly proposed spin (in comparison to old one)
	var oldSpin, newSpin;
	var <runModParam; // =1 if model runs, 0 if it does not
	var <>coolingParam; // =0 in normal model, =1 if cooling (energy must go down, no random fluctuation) 
	var <>smearingParam, <>alphaSmearing; // smearing just tested - destroys topological structures
	// GUI:
	var <>vecSize; // vector size in the GUI representation
	var <col; // color of the GUI background
	var <datawin, <phcontwin, <modcontwin, winSizeX, winSizeY, <>winPosX, <>winPosY;
	var <>vortShow, <vortexPlaces, <>spinShow;
	var neighsSpotlight, clickX, clickY, clickXold, clickYold;
	// SONIFICATION
	var <sonificationRange; 
	var <xySynths, <amplitude, <>phaseBaseFreq;
	var <>durParam, <envDurMax, <envDurMin; 
	var <sonifMax; // maximal number of neighbours allowed (due to comp. power)
	var <misTune; 
	var refresher; // see init

	var <>spiraleOrder;
	var <>spiraleOn;
	
	var s; 
	
	var <inShape;
	var <inPoints;
	var <phaseSynths;
	
	*new { |insize| ^super.new.init(insize) }


	init {arg insize;  
		
		dimension = 4;
		s = Server.internal;
		lsize = insize!dimension; 
		aCoord=0; bCoord=0; cCoord=0; dCoord=0;
		aziGUI=0; elevGUI=0;
		//MODEL:
		epsilon = 0.3;
		runModParam = 0;

		// GUI:
		vecSize = 17;
		col = Color.new( 0.5, 0.65116279069767, 1 );
		winPosX = 580; winPosY = 100;
	
	}




////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// THE GUIS	

////////////////////////////////////////////////////////////////////////////////////////////////////////////
	drawHalfCircs { |v1, v2, x, y|
		Pen.color = Color.gray(v1);
		Pen.addArc( (x * (vecSize))@(y * (vecSize)), vecSize/2, (3*pi/4), pi);
		Pen.fill;
		Pen.color = Color.gray(v2);
		Pen.addArc( (x * (vecSize))@(y * (vecSize)), vecSize/2, (7*pi/4), pi);
		Pen.fill;
	}

	drawCircs{|v, x, y|
		Pen.color = Color.gray(v);
		Pen.addArc( (x * (vecSize))@(y* (vecSize)), vecSize/2, 0, 2pi);
		Pen.fill;
	}

	redCirc {|x, y, m, n|
		if (x==m and:{y==n}) 									{Pen.strokeColor = Color.red; 
			Pen.addArc( (x * (vecSize))@(y* (vecSize)), vecSize/2, 0, 2pi);
			Pen.stroke};
	}

	circ {|x, y, col= (Color.red)|
			Pen.strokeColor = col; 
			Pen.addArc( (x * (vecSize))@(y* (vecSize)), vecSize/2, 0, 2pi);
			Pen.stroke;
	}
		
	// show one slide of the 4d data (color encoded)
	dataGUI { 

		var b, s1, s2, s3, s4, sAzi, sAziNumb, sElev, sElevNumb, sCoord, t1, drawCircs;
		var maxSize = [lsize[1], lsize[2], lsize[3]].maxItem;
		var radiusCoord = Array.fill2D(maxSize, 3);

		winSizeX = (vecSize * lsize[0]) + 300; 
		winSizeY = (vecSize * maxSize) + 220;
		
		datawin = SCWindow("Data slides", Rect(winPosX, winPosY, winSizeX, winSizeY)).front;
		datawin.view.background_(col);
		
		datawin.view.decorator = FlowLayout(datawin.view.bounds); 
		

		GUI.staticText.new(datawin, 400@15).string_("Time is shown on the vertical axis");
		datawin.view.decorator.nextLine;
		GUI.staticText.new(datawin, 80@15).string_("The other axis is (0=x, 1=y, 2=z):");
		sCoord = SCNumberBox(datawin, Rect(20, 20, 60, 20));

		datawin.view.decorator.nextLine;
		GUI.staticText.new(datawin, 50@15).string_("Azimuth");
		sAziNumb = SCNumberBox(datawin, Rect(20, 20, 60, 20));					
		sAzi = SC2DSlider(datawin, Rect(20, 20,80, 80))
			.x_(0.5)	// initial location of x
			.y_(0.5)	// initial location of y
			.action_({|sl|
				var angle, xcent, ycent;
				xcent = sl.x - 0.5;
				ycent = sl.y - 0.5;
				angle = ((atan((ycent.abs)/(xcent.abs)))).round(0.1);
				if(xcent>0 and:{ycent>0}) {aziGUI = (angle); 			sAziNumb.value_(angle.round(0.01))};
				if(xcent<0 and:{ycent>0}) {aziGUI = ((pi - angle)); 	sAziNumb.value_((pi - angle).round(0.01))};
				if(xcent<0 and:{ycent<0}) {aziGUI = ((pi + angle)); 	sAziNumb.value_((pi + angle).round(0.01))};
				if(xcent>0 and:{ycent<0}) {aziGUI = ((2pi - angle)); 	sAziNumb.value_((2pi - angle).round(0.01))};
//				aziGUI.postln;
				datawin.refresh;
			});
	
		GUI.staticText.new(datawin, 60@15).string_("Elevation");
		sElevNumb = SCNumberBox(datawin, Rect(20, 20, 60, 20));					
		sElev = SC2DSlider(datawin, Rect(20, 20, 80, 80))
			.x_(0.5)	// initial location of x
			.y_(0.5)	// initial location of y
			.action_({|sl|
				var angle, xcent, ycent;
				xcent = sl.x - 0.5;
				ycent = sl.y - 0.5;
				angle = ((atan((ycent.abs)/(xcent.abs)))).round(0.1);
				if(xcent>0 and:{ycent>0}) {aziGUI = (angle); 			sElevNumb.value_(angle.round(0.01))};
				if(xcent<0 and:{ycent>0}) {aziGUI = ((pi - angle)); 	sElevNumb.value_((pi - angle).round(0.01))};
				if(xcent<0 and:{ycent<0}) {aziGUI = ((pi + angle)); 	sElevNumb.value_((pi + angle).round(0.01))};
				if(xcent>0 and:{ycent<0}) {aziGUI = ((2pi - angle)); 	sElevNumb.value_((2pi - angle).round(0.01))};
//				elevGUI.postln;
				datawin.refresh;
			});
			
		GUI.staticText.new(datawin, 400@15).string_("At index:");
		datawin.view.decorator.nextLine;
		GUI.staticText.new(datawin, 15@15).string_("x=");
		s1 = SCNumberBox(datawin, Rect(20, 20, 60, 20)); 
		s1.value_(aCoord).action_({|ez| aCoord = ez.value; datawin.refresh;});
		GUI.staticText.new(datawin, 15@15).string_("y=");
		s2 = SCNumberBox(datawin, Rect(20, 20, 60, 20)); s2.value_(bCoord);
		s2.value_(bCoord).action_({|ez| bCoord = ez.value; datawin.refresh;});
		GUI.staticText.new(datawin, 15@15).string_("z=");
		s3 = SCNumberBox(datawin, Rect(20, 20, 60, 20)); s3.value_(cCoord);
		s3.value_(cCoord).action_({|ez| cCoord = ez.value; datawin.refresh;});
		datawin.view.decorator.nextLine;



		datawin.drawHook = { 
			var val, spotlightC, discrSampRate=10;
			var radiusCoord = Array.fill2D(maxSize*discrSampRate*3, 3), radiusCoordFin=Array.fill;
			var allpath, allpathInds, overCoords = Array.fill;
			Pen.translate(0+vecSize,(3*(20+4))+vecSize + 100);
			
			(maxSize*discrSampRate*3).do{|radius, r|
				radiusCoord[r][0] = (aCoord + ((r/10) * aziGUI.cos * elevGUI.cos).round).mod(lsize[0]);
				radiusCoord[r][1] = (bCoord + ((r/10) * aziGUI.cos * elevGUI.sin).round).mod(lsize[1]);
				radiusCoord[r][2] = (cCoord + ((r/10) * aziGUI.sin).round ).mod(lsize[2]);
			};

			// find the dimensions, where index runs through...
			radiusCoord.flop.do{|item, i| 
				if ((item.asSet.asArray.sort.findAll([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])).isNil) 
					{} { overCoords = overCoords.add(i) };
			};

			//... and choose first // one of them at random:
			overCoords = overCoords.first; 
			sCoord.value_(overCoords);

			allpath = radiusCoord.flop[overCoords].asSet.asArray;

			allpathInds = allpath.collect{ |jtem, j| radiusCoord.flop[overCoords].indexOfEqual(jtem) };

			allpathInds.do{ |ind, i| radiusCoordFin = radiusCoordFin.add(radiusCoord[ind]) };

			// draw data color encoded:
			radiusCoordFin.do{ |r|
				r.postln;
				lsize[3].do{|t|

					val = data[r[0]][r[1]][r[2]][t];
					this.drawCircs(val, r[overCoords], t);
				};
				this.circ(r[overCoords], 0);
			};
 				"".postln;

		};
		datawin.refresh;
	} 


	// show one slide of the 4d data (color encoded)
	dataGUI1 { 
	
		var b, s1, s2, s3, s4, t1, drawCircs;
		var maxSizeCols = [lsize[1], lsize[2], lsize[3]].maxItem;
	
		winSizeX = 3 * (vecSize * lsize[0]) + vecSize; 
		winSizeY = 2 * (vecSize * maxSizeCols) + (2 * vecSize);
		
		datawin = SCWindow("Data slides", Rect(winPosX, winPosY, winSizeX+(2*(vecSize*2)), winSizeY+(vecSize*2)+90)).front;
		datawin.view.background_(col);
		
		datawin.view.decorator = FlowLayout(datawin.view.bounds); 

		s1 = EZSlider(datawin, winSizeX @ 20, "Coord. A", ControlSpec(0, lsize[0]-1, \lin, 1), 
		{|ez| aCoord = ez.value; datawin.refresh; }, aCoord);
	
		s2 = EZSlider(datawin, winSizeX @ 20, "Coord. B", ControlSpec(0, lsize[1]-1, \lin, 1), 
		{|ez| bCoord = ez.value; datawin.refresh; }, bCoord);

		s3 = EZSlider(datawin, winSizeX @ 20, "Coord. C", ControlSpec(0, lsize[2]-1, \lin, 1), 
		{|ez| cCoord = ez.value; datawin.refresh; }, cCoord);
	
		s4 = EZSlider(datawin, winSizeX @ 20, "Coord. D", ControlSpec(0, lsize[3]-1, \lin, 1), 
		{|ez| dCoord = ez.value; datawin.refresh; }, dCoord);


		b = SCUserView(datawin, datawin.view.bounds)
			.mouseMoveAction_({|...args| 
				var clickXnow = ((args[1]/(vecSize)-0.5).round).clip(0,((3*lsize[0])+3));
				var clickYnow = ((args[2]/(vecSize)-1.5).round+1).clip(0,(2*maxSizeCols+1));

				
				if (clickXnow < lsize[0]) 
					{
						if (clickYnow < lsize[1])
							{aCoord = clickXnow; bCoord = clickYnow; 
							s1.valueAction_(aCoord); s2.valueAction_(bCoord) };
						if (clickYnow > maxSizeCols)
							{bCoord = clickXnow; cCoord = clickYnow-(maxSizeCols+2); 
							s2.valueAction_(bCoord); s3.valueAction_(cCoord)};
					}{};
					
				if (clickXnow > lsize[0] and:{clickXnow < (2*(lsize[0])+3)})
					{
						if (clickYnow < lsize[2])
							{aCoord = clickXnow-(lsize[0]+2); cCoord = clickYnow;
							s1.valueAction_(aCoord); s3.valueAction_(cCoord)};
						if (clickYnow > maxSizeCols)
							{bCoord = clickXnow-(lsize[0]+2); dCoord = clickYnow-(maxSizeCols+2);
							s2.valueAction_(bCoord); s4.valueAction_(dCoord)}; 
					}{};

				if (clickXnow >= (2*(lsize[0])+3))
					{
						if (clickYnow < lsize[3])
							{aCoord = clickXnow-(2*lsize[0]+4); dCoord = clickYnow;
							s1.valueAction_(aCoord); s4.valueAction_(dCoord)};
						if (clickYnow > maxSizeCols)
							{cCoord = clickXnow-(2*lsize[0]+4); dCoord = clickYnow-(maxSizeCols+2);
							s3.valueAction_(cCoord); s4.valueAction_(dCoord)};
					}{};

				["Spin at", [aCoord,  bCoord, cCoord, dCoord], "has value:", data[aCoord][bCoord][cCoord][dCoord]].postln;
				datawin.refresh;
			});
			
		if (data[0][0][0][0].size == 0)
		{		
			datawin.drawHook = { 
				var val, spotlightC;
				Pen.translate(0+vecSize,(4*(20+4))+vecSize);	
				// draw data color encoded:
				lsize[0].do{ |i|
					lsize[1].do{|j|
						val = data[i][j][cCoord][dCoord];
						this.redCirc(i, j, aCoord, bCoord);
						this.drawCircs(val, i, j);
					};
				};

				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[0].do{ |i|
					lsize[2].do{|j|
						val = data[i][bCoord][j][dCoord];
						this.redCirc(i, j, aCoord, cCoord);
						this.drawCircs(val, i, j);
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[0].do{ |i|
					lsize[3].do{|j|
						val = data[i][bCoord][cCoord][j];
						this.redCirc(i, j, aCoord, dCoord);
						this.drawCircs(val, i, j);
					};
				};
				Pen.translate(-2*(vecSize*lsize[0] + (vecSize*2)), vecSize*maxSizeCols + (vecSize*2));
				lsize[1].do{ |i|
					lsize[2].do{|j|
						val = data[aCoord][i][j][dCoord];
						this.redCirc(i, j, bCoord, cCoord);
						this.drawCircs(val, i, j);
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[1].do{ |i|
					lsize[3].do{|j|
						val = data[aCoord][i][cCoord][j];
						this.redCirc(i, j, bCoord, dCoord);
						this.drawCircs(val, i, j);
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[2].do{ |i|
					lsize[3].do{|j|
						val = data[aCoord][bCoord][i][j];
						this.redCirc(i, j, cCoord, dCoord);
						this.drawCircs(val, i, j);
					};
				};
			}
		};
		if (data[0][0][0][0].size == 4)
		{
			datawin.drawHook = { 
				var val1, val2, spotlightC;
				Pen.translate(0,90);	
				Pen.translate(vecSize,vecSize);	
				// draw data color encoded:
				lsize[0].do{ |i|
					lsize[1].do{|j|
						val1 = data[i][j][cCoord][dCoord][0];
						val2 = data[i][j][cCoord][dCoord][1];
						this.redCirc(i, j, aCoord, bCoord);
						this.drawHalfCircs(val1, val2, i, j)
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[0].do{ |i|
					lsize[2].do{|j|
						val1 = data[i][bCoord][j][dCoord][0];
						val2 = data[i][bCoord][j][dCoord][2];
						this.redCirc(i, j, aCoord, cCoord);
						this.drawHalfCircs(val1, val2, i, j)
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[0].do{ |i|
					lsize[3].do{|j|
						val1 = data[i][bCoord][cCoord][j][0];
						val2 = data[i][bCoord][cCoord][j][3];
						this.redCirc(i, j, aCoord, dCoord);
						this.drawHalfCircs(val1, val2, i, j)
					};
				};
				Pen.translate(-2*(vecSize*lsize[0] + (vecSize*2)), vecSize*lsize[2] + (vecSize*2));
				lsize[1].do{ |i|
					lsize[2].do{|j|
						val1 = data[aCoord][i][j][dCoord][1];
						val2 = data[aCoord][i][j][dCoord][2];
						this.redCirc(i, j, bCoord, cCoord);
						this.drawHalfCircs(val1, val2, i, j)
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[1].do{ |i|
					lsize[3].do{|j|
						val1 = data[aCoord][i][cCoord][j][1];
						val2 = data[aCoord][i][cCoord][j][3];
						this.redCirc(i, j, bCoord, dCoord);
						this.drawHalfCircs(val1, val2, i, j)
					};
				};
				Pen.translate(vecSize*lsize[0] + (vecSize*2), 0);
				lsize[2].do{ |i|
					lsize[3].do{|j|
						val1 = data[aCoord][bCoord][i][j][2];
						val2 = data[aCoord][bCoord][i][j][3];
						this.redCirc(i, j, cCoord, dCoord);
						this.drawHalfCircs(val1, val2, i, j)
					};
				};
			}
		};	
		datawin.refresh;
	} 



}

