LatticeQED : Object {
	
	var <ll;
	var <>beta;
	var <>eps; 
	var <nequi;
	var <aa;
	var <neib;
	
	*new {arg ill = 8, ibeta = 1, ieps = 0.01, inequi = 10;
		^super.new.init(ill,ibeta,ieps,inequi);
	}
	
	init {arg ill, ibeta, ieps, inequi; 
		ll = ill;
		beta = ibeta + 0.0;
		eps = ieps;
		nequi = inequi;
		aa = DoubleArray.newClear(ll*ll*ll*ll*5);
		neib = Int32Array.newClear(ll*ll*ll*ll*9);	
		^this.prInit;
	}

	readPathAt {arg orig, dim, level, array;
		var d;
		var t;
		var out;
		var test;
		if ((level > 4) || (level < 1)) {"Error! Level must be either 2 or 3".postln; ^this;} 
		{
			if ((dim.sum < 2) || (dim.sum > 3)) {"Error! Dimensio of curev must be 2 or 3".postln; ^this;} 	
			{
				d = array[(((dim.sum - 2)*4) + (level -1))];
				out = DoubleArray.newClear(d.size); 
				this.prMoore(out,orig,dim,d);
				^out;
			}
		}
	}
	
	data {arg norm = 'norm';
		var res = Array.newClear(this.ll*this.ll*this.ll*this.ll*4).clump(4).clump(this.ll).clump(this.ll).clump(this.ll);
		if (norm == 'norm') {
			this.prData(res,1,this.aa.minItem,this.aa.maxItem);
			^res;
		} {
			if (norm == 'orig') {
				this.prData(res,0,0,0);
				^res;
			} 
		}	
	}
	
	pointsInTime {arg samps, sum;
		var res = Array.fill(1000,{Array.fill(this.ll*samps,0)});
		this.prPInTime(res,samps,this.aa.minItem,this.aa.maxItem,sum);
		^res;
	}

	prInit {
		_QEDNew;
		^this.primitiveFailed;
	}
	
	sweeps {arg times;
		_QEDSweep;
		^this.primitiveFailed;
	}
	
	measure {
		_QEDMeasure;
		^this.primitiveFailed;
	}
	
	action {
		_QEDAction;
		^this.primitiveFailed;
	}

	gaugetrns {
		_QEDGaugeTrns;
		^this.primitiveFailed;
	}
	
	wloop {arg la=1, lb=1;
		_QEDWLoop;
		^this.primitiveFailed;
	}
		
	at {arg x, y, z, t;
		var res = DoubleArray.newClear(4);
		this.prPointAt(res,x,y,z,t);
		^res;
	}
	

	plakAt {arg point, plane, off, range = 1; 
		var res = DoubleArray.newClear(4*range);
		this.prPlakAt(res,range,off,plane,point);
		^res;
	}	
	
	timePlak {arg plane = [1,0,0,1], range = 1, samps = 1, sum = 0; 
		var res = Array.fill(1000,{Array.fill(((2*range) + (this.ll*2))*samps,0)});
		this.prTimePlakAt(res,range,[0,0,0,0],plane,this.aa.minItem,this.aa.maxItem,sum,samps);
		^res;
	}	
	
	plaquettesDict {arg point, plane, range = 1;
		var dir = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]];
		var planeSel = plane.indicesOfEqual(1);
		var res;
		var planesOut;
		var out = Dictionary.new;
		var names = [\x,\y,\z,\t];
		
		if (planeSel.size == 2) {
			res = this.plakAt(point,plane,[0,0,0,0],range);
			out.add(plane.collect{arg item, i; if (item != 0) {names[i]} {0}}-> res);
		}; 
		
		if (planeSel.size == 3) { 
			res = Array.new(6);
			planesOut = Array.new(24);
			planeSel.size.do{arg i; var t; t = plane.copy; t.put(planeSel[i],0); planesOut.add(t.flop ++ [0,0,0,0].flop);};
			4.do{arg i; var t = (plane*dir[i]); if (t != [0,0,0,0]) {planesOut.add((plane-t).flop ++ t.flop)}};
			
			planesOut.do{arg item; 
				var temp = this.plakAt(point,item[0],item[1],range);
				res.add(temp);
				
				out.add(item[0].collect{arg elem, i; if (elem != 0) 
						  						{names[i]} 
												{""} ++
												if(item[1][i] != 0) {"+" ++ item[1][i]} {if (elem != 0) {""} {"0"}}
									}
						-> temp);
			};
		};
		 
		if (planeSel.size == 4) { 
			res = Array.new(24);
			planesOut = Array.new(96);
			planeSel.size.do{arg i; var t; t = plane.copy; t.put(planeSel[i],0); planesOut.add(t.flop ++ [0,0,0,0].flop);};
			4.do{arg i; var t = (plane*dir[i]); if (t != [0,0,0,0]) {planesOut.add((plane-t).flop ++ t.flop)}};
			
			8.do{arg i; var t = planesOut[i][0].indicesOfEqual(1); 
				3.do{arg l; var v = planesOut[i][0].copy; v.put(t[l],0); planesOut.add(v.flop ++ planesOut[i][1].flop);};
				4.do{arg m; var w = (planesOut[i][0]*dir[m]);if (w != [0,0,0,0]) {planesOut.add((planesOut[i][0]-w).flop ++ (planesOut[i][1]+w).flop)}};
		 	};
			planesOut = planesOut.drop(8);
			planesOut = planesOut.separate.asSet.asArray;
			planesOut.do{arg item; 
				var temp = this.plakAt(point,item[0][0],item[0][1],range);
				res.add(temp);
				out.add(item[0][0].collect{arg elem, i; if (elem != 0) 
						  						{names[i]} 
												{""} ++
												if(item[0][1][i] != 0) {"+" ++ item[0][1][i]} {if (elem != 0) {""} {"0"}}
									}
						-> temp);
			};
		};
		out.keysValuesDo{arg key, value; (key.asSymbol ++ " -> " ++ value.asSymbol).postln;}
		^out;
	}	
	
	plaquettes {arg point, plane, range = 1;
		var dir = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]];
		var planeSel = plane.indicesOfEqual(1);
		var res;
		var planesOut;
		
		if (planeSel.size == 2) {
			res = this.plakAt(point,plane,[0,0,0,0],range);
		}; 
		
		if (planeSel.size == 3) { 
			res = Array.new(6);
			planesOut = Array.new(24);
			planeSel.size.do{arg i; var t; t = plane.copy; t.put(planeSel[i],0); planesOut.add(t.flop ++ [0,0,0,0].flop);};
			4.do{arg i; var t = (plane*dir[i]); if (t != [0,0,0,0]) {planesOut.add((plane-t).flop ++ t.flop)}};
			
			planesOut.do{arg item; 
				var temp = this.plakAt(point,item[0],item[1],range);
				res.add(temp);
				
			};
		};
		 
		if (planeSel.size == 4) { 
			res = Array.new(24);
			planesOut = Array.new(96);
			planeSel.size.do{arg i; var t; t = plane.copy; t.put(planeSel[i],0); planesOut.add(t.flop ++ [0,0,0,0].flop);};
			4.do{arg i; var t = (plane*dir[i]); if (t != [0,0,0,0]) {planesOut.add((plane-t).flop ++ t.flop)}};
			
			8.do{arg i; var t = planesOut[i][0].indicesOfEqual(1); 
				3.do{arg l; var v = planesOut[i][0].copy; v.put(t[l],0); planesOut.add(v.flop ++ planesOut[i][1].flop);};
				4.do{arg m; var w = (planesOut[i][0]*dir[m]);if (w != [0,0,0,0]) {planesOut.add((planesOut[i][0]-w).flop ++ (planesOut[i][1]+w).flop)}};
		 	};
			planesOut = planesOut.drop(8);
			planesOut = planesOut.separate.asSet.asArray;
			planesOut.do{arg item; 
				var temp = this.plakAt(point,item[0][0],item[0][1],range);
				res.add(temp);
			};
		};
		^res;
	}		
	
	prPlakAt {arg res, range, off, plane, point;
		_QEDPlakAt;
		^this.primitiveFailed;
	}
	
	prTimePlakAt {arg res, range, off, plane, min, max, sum, samps;
		_QEDTimePlakAt;
		^this.primitiveFailed;
	}
	
	prMoore {arg out,orig,dim,array;
		_QEDMoore;
		^this.primitiveFailed;
	}
	
	prData {arg res, norm, min, max;
		_QEDData;
		^this.primitiveFailed;
	}
	
	prPInTime {arg res, samps, min, max, sum;
		_QEDPInTime;
		^this.primitiveFailed;
	}
	
	prPointAt {arg res, x, y, z, t;
		_QEDPointAt;
		^this.primitiveFailed;
	}
}