LatticeXY : Lattice  { // 
	// MODEL:
	var <>coupling; // coupling variable
	var <> epsilon; // max. range of change of new randomly proposed spin (in comparison to old one)
	var oldSpin, newSpin;
	var <runModParam; // =1 if model runs, 0 if it does not
	var <>coolingParam; // =0 in normal model, =1 if cooling (energy must go down, no random fluctuation) 
	var <>smearingParam, <>alphaSmearing; // smearing just tested - destroys topological structures
//	// GUI:
	var <>vecSize; // vector size in the GUI representation
	var <col; // color of the GUI background
	var <spinwin, <phcontwin, <modcontwin, winSizeX, winSizeY, <>winPosX, <>winPosY;
	var <>vortShow, <vortexPlaces, <>spinShow;
	var clickX=0, clickY=0, clickXold, clickYold;
//
//	// SONIFICATION
	var <sonificationRange, <xySynths, <amplitude, <>phaseBaseFreq;
	var <sonifMax; // maximal number of neighbours allowed (due to comp. power)
	var <>misTune; // mistune the base frequency depending on distance to clicking point
	var refresher; // task that updates synths e.g. each 10 ms
	var sampsPerPoint, intpol; // samples per data val; array of interpolated vals
	var numsynths, numpoints; // number of synths and nb of data vals (4=plaquette)
	var <bufs1, <bufs2, lagBwBufs, bufChanger; // buffers of interpolated vals and lagtime between buffer change, changer = 0 or 1
	var phaseSites, phaseDiffs;
	var <>spiraleOrder, <>spiraleOn;
	
	var s; // server
	
	*new { |insize=30, incoupling=0.9| ^super.new.init(insize, incoupling) }

	init {arg insize, incoupling;  
	
		s = Server.default;
		lsize = insize!2;
		dimension = 2;
		coupling = incoupling;
	
		//MODEL:
		epsilon = 0.3;
		runModParam = 0; coolingParam = 0; smearingParam = 0;
	
		// GUI:
		vecSize = 7; winPosX = 580; winPosY = 100;
		col = Color.new( 0.48837209302326, 0.68604651162791, 0.66279069767442 );
		vortShow = 0; spinShow = 1;
	
		//SONIFICATION:
		sonificationRange = 0;
		sonifMax = 5; 
		phaseBaseFreq = 1102.5; //phaseBaseFreq = (9*44100)/(numpoints*sampsPerPoint); // changes baseFreq with numpoints!
		numpoints = 4;
		sampsPerPoint = 3 * 44100 / ( (numpoints-1) * phaseBaseFreq ); //sampsPerPoint = 90;
		amplitude = 0.5;
		bufChanger = 0; lagBwBufs = 0.1;
		misTune = 5; // in Hz for base phaseBaseFreq, maximal misTune or less (depending on distance) 
		spiraleOrder = 3; spiraleOn = 0;
		
		this.xySynthDefNew(s);
		
		refresher = Task ({ arg env; 
							var index = 0;
							clickXold = 99999; clickYold = 99999;
							clickX = 99999; clickY = 99999;

							inf.do {
								if(sonificationRange != 0) // if the sonification is turned on:
								{ 												if((clickX != clickXold) || (clickY != clickYold)) 									{ // if a new point was clicked at:
										this.funcSynth(clickX, clickY); index = 0;
										clickXold = clickX; clickYold = clickY;
									}
									{ // same clicking point, but model runs, (after first updates (indices)):
										if ( (index >= 5) && (runModParam == 1)) // WARUM index>=8 ???
											{ this.funcSynth(clickX, clickY); index = 0 }; 
									};
									index = index + 1; 
//									// sicherheit damit Integrator nicht numerisch explodiert...
								};
								0.05.wait;
							};
						});
		this.randDataXY;
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// FOR THE MODEL

////////////////////////////////////////////////////////////////////////////////////////////////////////////

	randDataXY { 
		data = Array.fill2D(lsize[0], lsize[1], { 2pi.rand }); 
		^data; 
	}
	
	nextFrame {
		data.do { |line, lineIndex| 
			data[lineIndex].do { |newSpin, colIndex|
				data[lineIndex][colIndex] = this.formula(this.energyDelta(lineIndex, colIndex));
				}
			};
		^data
	}

	smearedFrame { 
		data.do { |line, lineIndex| 
			data[lineIndex].do { |newSpin, colIndex|
				data[lineIndex][colIndex] = this.smearing(lineIndex, colIndex, alphaSmearing)
				}; 
			};
		^data
	}
	
	nextStep { if (smearingParam == 0) {data = this.nextFrame} {data = this.smearedFrame}; ^data }
	
	neighborsVals { |a, b|
		var neighborsInM;
		neighborsInM = [
			data.at(a).wrapAt(b + 1),
			data.at(a).wrapAt(b - 1), 
			data.wrapAt(a - 1).at(b), 
			data.wrapAt(a + 1).at(b),
		];
		^neighborsInM
	}

	energyDelta {|x, y|
		var energyDeltaNew = 0, energyDeltaOld = 0, neighbors, energyDeltaNeigh = 0;
		
		oldSpin = data[x][y];
		newSpin = (data[x][y] + (epsilon * rrand(-1.0, 1.0))).mod(2pi);
	
		// calculate new energy depending on deltas with neighboring spins:
		neighbors = this.neighborsVals(x, y);
		neighbors.do {|item, i|
			energyDeltaNew = energyDeltaNew + (cos(newSpin - item)); // if far apart - small deltaEnergy
			energyDeltaOld = energyDeltaOld + (cos(oldSpin - item));
		};
		energyDeltaNeigh = energyDeltaNew - energyDeltaOld; // ...pos>>oldEnergyDelta smaller
	
		^energyDeltaNeigh
	}
	
	formula {|energyDelta|
		var random, rho;
		var spinVal;
	
		random = rrand (0.0, 1.0);
		rho = (coupling * energyDelta); 
	
		if ( rho >= 0, { 	
			spinVal = newSpin;
			}, { 
				if (coolingParam == 0, // if coolingParam != 0: cooling!
					{if ( random <= exp(rho), { spinVal = newSpin }, {spinVal = oldSpin } ) },
					{ spinVal = oldSpin });
		}); 
		^spinVal
	}

	energy {|c, d|
		var dphi1, dphi2, energy;
		dphi1 = data[c][d] - data[c].wrapAt(d+1);
		dphi2 = data[c][d] - data.wrapAt(c+1)[d];
		energy = 2 - (cos(dphi1)) - (cos(dphi2));
		^energy
	}
	
	calcEnergy {
		var allEnergy = 0;
		data.do { |line, lineIndex| 
			data[lineIndex].do { |newSpin, colIndex|
				allEnergy = allEnergy + this.energy(lineIndex, colIndex);
			}
		};
		allEnergy = allEnergy / (2*lsize[0].squared);
		^allEnergy
	}
	
	smearing {|x, y| // destroys topology!!!
		var smearedSpin, thisSpin = data[x][y];
		smearedSpin = ((1-alphaSmearing) * thisSpin) + (alphaSmearing * neighborsVals(x, y).sum / 4);
		smearedSpin = smearedSpin.mod(2pi);
		^smearedSpin
	}

	runModelTask { |numb|
		Tdef(\runModel, {
			numb.do{
					this.nextStep;
					this.updateWins;
					0.1.wait;
			};
			"Tdef runModel has finished!"	
		});
		Tdef(\runModel).play;
	}
	
	stopModelTask { Tdef(\runModel).stop }

	createEquilibrate {|coupl, times=1, noRand = 0, noUpdate = 0| 
		Tdef(\runEquilibrate,{
			if (noRand == 0) {this.randDataXY} {};  
			if (coupl.isNil) {coupling} {coupling = coupl};
			epsilon = 0.8; ( 5 * lsize[0] * times).do{ this.nextStep; };
			epsilon = 0.3; ( 5 * lsize[0] * times).do{ this.nextStep; };
			if (noUpdate == 0) {this.updateWins};
			"Equilibration finished.".postln;
		});
		Tdef(\runEquilibrate).play;	
	}


////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// THE GUIS	

////////////////////////////////////////////////////////////////////////////////////////////////////////////


	spinGUI {|showVort = 0|
		
		var b;
		var spotlightCenter, vortexCenter;
		var spotlightCenterPrev;
		
		winSizeX = (2*vecSize+1)*lsize[0]+(vecSize*2);
		winSizeY = (2*vecSize+1)*lsize[1]+(vecSize*2);
	
		spinwin = SCWindow("XY model", Rect(winPosX, winPosY-40, winSizeX, winSizeY)).front;
		spinwin.view.background_(col);
		
		spinwin.view.decorator = FlowLayout(spinwin.view.bounds); 
	
		b = SCUserView(spinwin, spinwin.view.bounds.insetBy(vecSize, vecSize))
			.mouseMoveAction_({|...args| 
				var clickXnow = ((args[2]/(vecSize*2 + 1)).round-1).clip(0,(lsize[1]-1));
				var clickYnow = ((args[1]/(vecSize*2 + 1)).round-1).clip(0,(lsize[0]-1));

				clickX = clickXnow;
				clickY = clickYnow;
				["Spin at x", clickX, " and y", clickY, "has value", data[clickX][clickY]].postln;
				spinwin.refresh;
			});

		spinwin.drawHook = { 
			var colorFunc, val, spotlightC;
			var modSize = (2*vecSize+1)*lsize[0];
			colorFunc = {Color.black}; 
	
			if (sonificationRange>0) // show Spotlight of neighbours around clicking point:
			{
				phaseSites.do{|quarters, j|
					Pen.color = Color.new( 0.88372, 0.87209, 0.44186 + 0.3.rand);

					if (spiraleOn == 0)
						{
							spotlightCenter = (1 + quarters[0]*(vecSize*2 + 1)) + vecSize;
							Pen.addArc((spotlightCenter[1])@(spotlightCenter[0]), vecSize * 2, 2pi, 2pi);
							Pen.fill;
						}{
							quarters.do{|item, i|
								var previous = quarters.wrapAt(i-1);
								spotlightCenter = (1 + item * (vecSize*2 + 1));
								spotlightCenterPrev = ( 1 + previous * (vecSize*2 + 1));
								if ((previous[0]-item[0]).abs > 1 or:{(previous[1]-item[1]).abs > 1})
									{Pen.moveTo((spotlightCenter[1])@(spotlightCenter[0]))}
									{Pen.moveTo((spotlightCenterPrev[1])@(spotlightCenterPrev[0]))};
								Pen.lineTo((spotlightCenter[1])@(spotlightCenter[0]));
								Pen.stroke;
							};
						};
				};
			};
	
		
			if (vortShow == 1) // show vortices in GUI:
				{
					vortexPlaces = [this.findPM2pi('quarter')[1], this.findPM2pi('quarter')[3]];
					
					vortexPlaces.do{|vortAndAvort, v|
						vortAndAvort.do{|vortex, i|
							vortexCenter = (1 + vortex*(vecSize*2 + 1)) + vecSize;
							if (v == 0) {Pen.color = Color.red} {Pen.color = Color.white};
							Pen.addArc((vortexCenter[1])@(vortexCenter[0]), vecSize * 2 + vecSize, 2pi, 2pi);
							Pen.perform([\stroke].choose);
						};
					};
				};
			if (spinShow == 1)
				{
					// draw spins:
					Pen.translate(0,(2*vecSize+1));		
					lsize[0].do{ |i|
						lsize[1].do{|j|
							val = data[i][j];
							Pen.strokeColor = colorFunc.(val/2pi).set;
							Pen.translate((2*vecSize+1), 0);
							if (i>0 and:(j == 0), {Pen.translate(neg(2*vecSize+1)*lsize[0], (2*vecSize+1))});
							Pen.moveTo(0@0);
							Pen.strokeOval(Rect(0, 0, 1, 1););
							Pen.moveTo(0@0);
							Pen.lineTo((cos(val)*vecSize)@(neg(sin(val))*vecSize));//neg(y)...gui beginnt links OBEN!
							Pen.stroke;
						};
					}
				};
			}
	}	


	modelControlGUI { 	
						
		var spotlightCenter, vortexCenter;
		var b1, b2, b3, b4, s1, s2;
			
		modcontwin = SCWindow("Spin model - control", Rect(winPosX, winPosY+winSizeY-10, winSizeX, 55)).front;
		modcontwin.view.background_(col);
		
		modcontwin.view.decorator = FlowLayout(modcontwin.view.bounds); 

		b1 = SCButton(modcontwin, Rect(0,0,100,20))
			.states_([
				["start model!", Color.black, Color.red],
				["stop model!", Color.white, Color.black],
			])
			.action_({ arg butt; if (butt.value == 1) 
				{runModParam = 1; this.runModelTask(inf) } 
				{runModParam = 0; this.stopModelTask }}) 
			.value_(runModParam); 
	
		b2 = SCButton(modcontwin, Rect(0,0,100,20))
			.states_([
				["start cooling!", Color.black, Color.red],
				["no cooling!", Color.white, Color.black],
			])
			.action_({ arg butt; if (butt.value == 1) 
				{coolingParam = 1 } 
				{coolingParam = 0 }}) 
			.value_(coolingParam); 
			
		b3 = SCButton(modcontwin, Rect(0,0,100,20))
			.states_([["randomize"]])
			.action_({this.randDataXY; this.updateWins});
	
		b4 = SCButton(modcontwin, Rect(0,0,100,20))
			.states_([["show vortices!"], ["no vortices!"]])
			.action_({  arg butt; if (butt.value == 1) 
				{
				vortShow = 1; spinwin.refresh 
				} 
				{vortShow = 0; spinwin.refresh } })
			.value_(vortShow); 
				
		modcontwin.view.decorator.nextLine;
		
		s1 = EZSlider(modcontwin, 200 @ 20, "Temperature", ControlSpec(0, 2, \lin), 
			{|ez| coupling = (1/(ez.value)) }, (1/coupling), false, 80, 50).round(0.1);
		
		s2 = EZSlider(modcontwin, 200 @ 20, "Epsilon parameter", ControlSpec(0, 1, \lin), 
			{|ez| epsilon = ez.value }, epsilon, false, 100, 50).round(0.1);

		modcontwin.refresh;
		
	}
	
	
	phaseControlGUI { 	
						
		var spotlightCenter, vortexCenter, popupNeighs, popupSpiral;
			
		phcontwin = SCWindow("Phase sonification", Rect(winPosX, winPosY+winSizeY+70, winSizeX, 40)).front;
		phcontwin.view.background_(col);
		
		phcontwin.view.decorator = FlowLayout(phcontwin.view.bounds); 

		popupNeighs = SCPopUpMenu(phcontwin,Rect(0,0,100,30));
			popupNeighs.items = (["neighbours", "range 1", "range 2", "range 3", "range 4", "range 5"]);
			popupNeighs.background_(Color.white);
			popupNeighs.action = { |neigh| 
				spiraleOn = 0;  
				sonificationRange = neigh.value;
				numsynths = 0; sonificationRange.do{|i| numsynths = numsynths + (i+1)}; numsynths = numsynths * 4 + 1;
				refresher.stop; this.makeSynths; refresher.play; 
				};
			popupNeighs.valueAction = sonificationRange;

		popupSpiral = SCPopUpMenu(phcontwin,Rect(0,0,100,30));
			popupSpiral.items = [["spirale"], Array.fill(lsize[0], {|i| ("order " ++ (i+1)).asString};)].flatten;
			popupSpiral.background_(Color.white);
			popupSpiral.action = { |neigh| 
				spiraleOn = 1; 
				sonificationRange = neigh.value;
				if (sonificationRange > 0) {numsynths = 1} {numsynths = 0};
				refresher.stop; this.makeSynths; refresher.play; 
				};
			popupSpiral.valueAction = sonificationRange;
	
		phcontwin.refresh;
	}

	makeGUIs { this.spinGUI; this.modelControlGUI; this.phaseControlGUI; }
	
		// update GUI
	updateWins { defer { try { spinwin.refresh; phcontwin.refresh } } }
	
	// show by blinking where a spin is in the gui:
	showPointinGUI { |i, j, waiting=0.2, repeating=1|
		var value = data[i][j];
		spinwin.front;
		Task({
			repeating.do{
				[0, (pi/2), pi, (3*pi/2)].do{|circle| data[i][j] = circle; this.updateWins; waiting.wait }
			};
			data[i][j] = value; this.updateWins;
		}).play;
	}
	
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//    // FOR FINDING VORTICES
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

	
	findPM2pi {|whichSpins='quarter'|
		var numbP2pi = 0, placeP2pi = [], numbM2pi = 0, placeM2pi = [], ntimes;
			data.do{|lines, i|
				lines.do{|spins, j|
					if (whichSpins == 'triang') {ntimes = 4} {ntimes = 1};
					ntimes.do{|tind|
						var whichvecs, whichsum = 0;

						if (whichSpins == 'quarter')
							{ this.quarters(i,j).do{|k| whichvecs = whichvecs ++ [data[k[0]][k[1]]];
							}}; 
						if (whichSpins == 'triang')
							{ this.triangs(i,j,tind).do{|k| whichvecs = whichvecs ++ [data[k[0]][k[1]]]}};
						if (whichSpins == 'spirale')
							{this.makeSpiral(spiraleOrder, i, j).do{|k| whichvecs = whichvecs ++ [data[k[0]][k[1]]]}};

						whichvecs.do{|l, ind| 
							var diff = this.relAnglDiff((whichvecs[(ind+1).mod(whichvecs.size)]), whichvecs[ind]);
							whichsum = whichsum + diff;
						};

						if ((whichsum.round(0.000001)) == (2pi.round(0.000001)) ) 
						{numbP2pi = numbP2pi + 1; placeP2pi = placeP2pi ++ [[i, j]];};
						if ((whichsum.round(0.000001)) == (-2pi.round(0.000001)) ) 
						{numbM2pi = numbM2pi + 1; placeM2pi = placeM2pi ++ [[i, j]];};
					}
				}
			};
		^[numbP2pi, placeP2pi, numbM2pi, placeM2pi]; 

	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// FOR THE SONIFICATION

////////////////////////////////////////////////////////////////////////////////////////////////////////////

	xySynthDefNew { arg s;
		SynthDef(\xySynthDefK2, {
			arg 	chooseBuf = 0, numpoints = 5, phaseBaseFreq = 1102.5, amp = 0.3, distance = 1,
			phloop1, phloop2, synth1, synth2, lagtime = 1, buffernum1=0, buffernum2=1, out, sonif=1,
			envDurMax = 1, envDurMin = 0.1, misTune = 3, grainOn = 1;
		var grainEnv, grain, grainDur, grainAmp, baseFreq;
		var off1=0, off2=0, last1, last2;
		
		var trig = Impulse.ar(44100/(BufFrames.kr(buffernum1)));
		var phase = Phasor.ar(trig, BufRateScale.kr(buffernum1), 0, BufFrames.kr(buffernum1));
		
		phloop1 = BufRd.ar(1, buffernum1, phase) * 2pi;
		phloop2 = BufRd.ar(1, buffernum2, phase) * 2pi;	
	last1 = SinOsc.ar(0, 0, 0.1); // no offset makes it the same as playbuf!
	last2 = SinOsc.ar(0, 0, 0.1); // no offset makes it the same as playbuf!

		baseFreq = phaseBaseFreq + ((distance/sonif) * misTune);

		off1 = ((Integrator.ar(last1*trig, 1*(1-chooseBuf))) - last1).mod(2pi);
		off2 = (Integrator.ar(last2*trig,  1*(chooseBuf))  -   last2).mod(2pi);
//		off1 = IntegratorMod.ar(last1*trig, (1-chooseBuf), 2pi); 
//		off2 = IntegratorMod.ar(last2*trig, chooseBuf, 2pi); 
		synth1 = (SinOsc.ar(baseFreq, (phloop1+off1).mod(2pi))) - (SinOsc.ar(baseFreq, off1));
		synth2 = (SinOsc.ar(baseFreq, (phloop2+off2).mod(2pi))) - (SinOsc.ar(baseFreq, off2));

		grainDur = (distance/sonif) * (envDurMax-envDurMin) + envDurMin;
		grainAmp = 1 - ((distance/sonif) * 0.9);
		grainEnv = Env.perc(grainDur * 0.2, grainDur * (1-0.2), grainAmp, (distance/sonif).neg);
		grain = EnvGen.kr(grainEnv,Trig.kr(Impulse.kr(1/grainDur),grainDur));

		out = SelectX.ar(chooseBuf.lag(lagtime), [synth1, synth2]);

// with filtering:	
//		Out.ar(0, Pan2.ar((BRF.ar(out, phaseBaseFreq, 3)) , 0) * amp * grain); 
		if (grainOn == 1) 
			{ Out.ar(0, Pan2.ar(out) * amp * grain) } 
			{ Out.ar(0, Pan2.ar(out) * amp) };
//MIT DEM FILTER VERSCHWINDET auch DAS KLICKEN???!!!
	}).send(s);
	}
								
	makeSynths {
		bufs1.do{ |item, i| item.free };
		bufs2.do{ |item, i| item.free };
		xySynths.do{ |item, i| item.free };

		bufs1 = Array.fill( numsynths, {Buffer.alloc(s, sampsPerPoint * (numpoints - 1), 1)} );  
		bufs2 = Array.fill( numsynths, {Buffer.alloc(s, sampsPerPoint * (numpoints - 1), 1)} ); 
		xySynths = Array.fill(
			numsynths, {|i|
			Synth.new(\xySynthDefK2, [
				\amp, amplitude,
				\phaseBaseFreq, phaseBaseFreq,
				\sampsPerPoint, sampsPerPoint,
				\buffernum1, bufs1[i].bufnum,
				\buffernum2, bufs2[i].bufnum,
				\chooseBuf, 0,
				\lagtime, lagBwBufs,
				\sonif, (sonificationRange + 0.1), 
				\envDurMax, 0.5, 
				\envDurMin, 0.1,
				\misTune, misTune,
				\grainOn, 0
			]);
			}
		);
	}


	// get phase sites in the clicking neighbours or spirale range:
	getphaseSites { arg x, y;		
		var neighs;
//		phaseSites = [[x, y]].postln;          
		if (spiraleOn == 1) 
			{	phaseSites = [ this.makeSpiral(sonificationRange, x, y).drop(1) ];
				numpoints = phaseSites[0].size; 	sampsPerPoint = 3 * 44100 / ( (numpoints-1) * phaseBaseFreq );
			}
			{ 
				sonificationRange.do{|i| neighs = neighs ++ this.surround((i+1), x, y, data); };
				numpoints = 4; sampsPerPoint = 3 * 44100 / ( (numpoints-1) * phaseBaseFreq );
				phaseSites = [this.quarters(x, y)];
				neighs.do{|neighbour| phaseSites = phaseSites ++ [this.quarters(neighbour[0], neighbour[1])] };
			};
	}
	
	phInterpol { arg i, chooseBuf2Fill;
		intpol = Array.fill( sampsPerPoint * (numpoints - 1) + 1,  0);
		(numpoints).do{|n| if(n==0) {intpol[0] = phaseDiffs[0] } {intpol[(n * sampsPerPoint)] = intpol[((n-1) * sampsPerPoint)] + phaseDiffs[n]} };
		// ascending sum of phase differences!
		(numpoints - 1).do{|n| 
			var thisi = (n * sampsPerPoint), nexti = ((n+1).mod(numpoints)) * sampsPerPoint; // last index = first
			var thisval = intpol[thisi], nextval = intpol[nexti], interpolator;

			sampsPerPoint.do{|val, v|
					interpolator = (cos( (v/(sampsPerPoint-1))*pi) + 1)/2; // cosinus interpolation between phase values
					intpol[((thisi+v).mod((numpoints-1) * sampsPerPoint))] = (interpolator * thisval + ((1-interpolator) * (intpol[nexti])));
			} 
		};		
		intpol = (intpol**3)/(8*(pi**3));
		if (chooseBuf2Fill == 0) { bufs1[i].setn(0, intpol) } { bufs2[i].setn(0, intpol) };
	}

	funcSynth {|x, y|	
		var diag = (lsize[0].squared + lsize[0].squared).sqrt;
		var playingBuf;

		this.getphaseSites(x, y);

		bufChanger = [1,0].at(bufChanger); // respectively the other buffer, 0 oder 1!

		phaseSites.do{|phaseSiteLoop, ineigh| 
			var xneighData = (phaseSiteLoop[0][0]-x), yneighData = (phaseSiteLoop[0][1]-y); 
			var phaseloop = Array.fill(phaseSiteLoop.size); 

			phaseDiffs = Array.fill(phaseSiteLoop.size);
			if ( xneighData>sonifMax ) {xneighData = xneighData - lsize[0]};
			if ( xneighData<(sonifMax.neg) ) {xneighData = xneighData + lsize[0]};
			if ( yneighData>sonifMax ) {yneighData = yneighData - lsize[0]};
			if ( yneighData<(sonifMax.neg) ) {yneighData = yneighData + lsize[0]};
			phaseSiteLoop.do{|site, p| phaseloop[p] = data[site[0]][site[1]] }; 
			phaseloop.do{|phaseVal, p| phaseDiffs[p] = this.relAnglDiff(phaseloop.wrapAt(p-1), phaseVal); };

//			phaseDiffs.postln;
			this.phInterpol(ineigh, bufChanger); 

			xySynths[ineigh].setn([
				\chooseBuf, bufChanger, 
				\distance, (((xneighData.squared)+(yneighData.squared)).sqrt),
				\sonif, (sonificationRange + 0.1) // safer -> sonif !>0 
				]); 
			}; 
		}




	
}