

/**
create pseudo climate data: temperature over q.sizes years in 3d space
create pseudo instanton: 4d Gussian bulp
**/
PseudoData {

	var <>dim;
	var <>sizes, size1, size2, size3, size4;


	var <>climateChange; 
	var heightFunc;  
	var latFunc; 
	var mountFunc;  
	var gauss ;
	var timeFunc;  
	var pseudoClimate;

	var makeInstanton;

	var <>pseudodata;

	*new {|indim=4, insizes=(5!indim)|  ^super.new.init(indim, insizes)}


	init { arg indim, insizes;
	sizes = insizes;
	size1 = sizes[0];
	size2 = sizes[1];
	size3 = sizes[2];
	size4 = sizes[3];
	dim = indim;


	climateChange = 0.1; // big climate change
	//climateChange = 0.01; // tiny climate change
	}
		
	heightFunc {|ind, size| 	// a=height: "temperature" drops logarithmically with height
		var h = (1/(log(5*ind/size+2)));
		^h;
	}  

	latFunc {|ind, size| 		// b="latitude": temperature drops as sinus with latitude
		var l = (sin(((ind)/(size))*(pi/2)+(pi/2)));
		^l;
	} 

	mountFunc {|ind, size| 	// straight plateau like mountain
		var m;
		if (ind<3 or:{ind>7}) {m=1} {m=((2*(ind+1)/(size/2) - (1/2))**2)};
		^m;
	}
	  
	gauss { |logVec, sigma=(0.03.sqrt), mu=0.3|		// gaussian mountain
		var g;
		g = 1/(sigma * ((2pi).sqrt)) * exp( neg( ((logVec - mu).squared) / (2*(sigma.squared)) ) );
		^g;
	}
	
	timeFunc {|ind, size| 	// d="time": periodical up&down over 4 years
		var t = sin((ind+1)/(size)*2pi) + (climateChange * ind);
		^t;
	}
	
	pseudoClimate {|height=1, lat = 1, long = 1, time = 1, rand = 1|
		var clima = 
		Array.fillND(sizes, //sizes!4, 
			{arg a, b, c, d; 
			((this.heightFunc(5*a, size1))*height) + 
			((this.latFunc(b, size2))*lat) + 
			((neg(this.gauss((c/(size3/2))-1))  + this.mountFunc(c, size3) )*long) + 
			((this.timeFunc(d, size4))*time) + 
			((rrand(0.1, 0.2))*rand) // random fluctuation
		});
		pseudodata = clima;
		^pseudodata;
	}


	
	
	makeInstanton {|rand=0|	
		var stepN = 12, testdataG, allSteps, gaussianDist, mid;
		
		testdataG = Array.fillND(sizes, 0);
		allSteps = Array.fill(stepN, {|i| i-(stepN/2)+0.5});
		
		gaussianDist = Array.fill(4, 
			{ |dims| 
			allSteps.collect({ |xval, i|
				this.gauss(xval, 1, 0);
			});
		});
		gaussianDist.printAll;
	
			// fill the testdata with the Gaussian shape in the middle
		mid = [8,8,8,16]; // mid point
		stepN.do{ |j| 
			testdataG[(mid[0]/2+j)][8][8][16] = gaussianDist[0][j];
			testdataG[8][(mid[1]/2+j)][8][16] = gaussianDist[1][j];
			testdataG[8][8][(mid[2]/2+j)][16] = gaussianDist[2][j];
			testdataG[8][8][8][(mid[3]/2+j)] = gaussianDist[3][j]
		};

			// smear between the 2d curves to get a 4d object (this takes a few sec)
		5.do{ 
			testdataG.do { |xvals, i|
				xvals.do { |yvals, j|
					yvals.do { |zvals, k|
						zvals.do { |vals, t|
							testdataG[i][j][k][t] = 
							(((
							testdataG.wrapAt(i+1).wrapAt(j).wrapAt(k).wrapAt(t) +
							testdataG.wrapAt(i-1).wrapAt(j).wrapAt(k).wrapAt(t) +
							testdataG.wrapAt(i).wrapAt(j+1).wrapAt(k).wrapAt(t) +
							testdataG.wrapAt(i).wrapAt(j-1).wrapAt(k).wrapAt(t) +
							testdataG.wrapAt(i).wrapAt(j).wrapAt(k+1).wrapAt(t) +
							testdataG.wrapAt(i).wrapAt(j).wrapAt(k-1).wrapAt(t) +
							testdataG.wrapAt(i).wrapAt(j).wrapAt(k).wrapAt(t+1) +
							testdataG.wrapAt(i).wrapAt(j).wrapAt(k).wrapAt(t-1)
							) / 8 )
							+ ((rrand(0.0, 0.01))*rand));
						};
					};	
				};
			};
		};
	pseudodata = testdataG;
	^pseudodata;
	}
	
	placeSingles {|where=([0, 0, 0, 0]), rand=0|
		var singleData = Array.fillND(sizes, { rrand(0.0, 1.0) * rand });

		where.do{|item, i|
			if (dim == 2) {singleData[item[0]][item[1]] = 1};
			if (dim == 3) {singleData[item[0]][item[1]][item[2]] = 1};
			if (dim == 4) {singleData[item[0]][item[1]][item[2]][item[3]] = 1};
		};
		pseudodata = singleData;
		^pseudodata;	
	}
}
