/**
	Presentation of the Shepard Principle with pitch, timbre and rhythm
	Implemented for datenhoerraum quantenphysik, 8.11.2009, graz
	Developed by K. Vogt
	(shepard tones based on a sonenvir-version by Alberto de Campo)
**/
ShepardShowClass {

	var rthmRate; // ...per second
	var ampTable, freqTable; // for shepard
	var buf1, buf2;	// buffers for shepard
	var vortexNumb, antiturn; // number of tones per tone
	var pPar, tPar, rPar, pitchParam, timParam, rthmParam; // pitch, timbre and rhythm parameters
	var css;	// synth

	// gui variables
	var w; 
	var t, u, v;
	var b11, b1, b2, b3, b4, b5, b6, b7, b8, b9, b0, s1, s2, s3;
	var alltasks, turner;
	
	var s;
	
	*new { ^super.new.init }
	
	init {
		s = Server.default;

		rthmRate = 3; // ...per second
		ampTable = Signal.hanningWindow(1024).squared;
		freqTable = Signal.newClear(1024).waveFill({ arg i; 0.5 ** i * 10000 }, 0, 10);
		
		buf1 = Buffer.loadCollection(s, freqTable);
		buf2 = Buffer.loadCollection(s, ampTable);
	
		vortexNumb = 50; 
		pPar = 0;
		tPar = 0; 
		rPar = 1; 
		antiturn = 1;
		
		alltasks = [
		[{ pPar = 1; tPar = 0; rPar = 0; }, "Rotation der Frequenzen (Shepard)"],
		[{ pPar = 0; tPar = 1; rPar = 0; }, "Rotation der Klaenge"],
		[{ pPar = 0; tPar = 0; rPar = 1; }, "Rotation des Rhythmus"],
		[{ pPar = 1; tPar = 0; rPar = 1; }, "Rotation Shepard und Rhythmus"],
		[{ pPar = 0; tPar = 1; rPar = 1; }, "Rotation Timbre und Rhythmus"]
		];
		
		turner = Task ({
			inf.do{
				vortexNumb.do{|i|
					var param = i.linlin(0.0, vortexNumb, antiturn-0,1-antiturn);
					pitchParam = [0, param, 0.0.rrand(1.0)][pPar];
					timParam = [0, param, 0.0.rrand(1.0)][tPar];
					rthmParam = [0, param, 0.0.rrand(1.0)][rPar];
					css.set(\ph, pitchParam, \timbre, timParam, \rthm, rthmParam, \rtmrate, rthmRate);
					(1/rthmRate).wait;
					};
				};
			});
	
		this.synthDefs(s);
		pitchParam = 0; timParam = 0; rthmParam = 0;
		this.shepardGUI;
	}
	
	synthDefs { arg s;
		// first synth: shepards and rhythm
		SynthDef(\testcss1, {arg buffer1, buffer2, ph = 0, rthm = 0, rtmrate=2; 
			var freqs, amps, impulse, env, mul;
			
			impulse = Impulse.ar(rtmrate, [0, rthm]);				env = Env.perc(0.05, 1/(rtmrate*2), 1, -4);
			mul = EnvGen.ar(env,impulse);
		
			freqs = BufRd.ar(1, buffer1,  SinOsc.ar(0,(pi/2),(0..9)*102.4 + (ph*102.4)));
			amps = BufRd.ar(1, buffer2,  SinOsc.ar(0,(pi/2),(0..9)*102.4 + (ph*102.4)));
		
			Out.ar(0, (Mix.ar(SinOsc.ar(freqs, 0, amps * 0.000001) * mul) )!2 );
		}).send(s);
		
		// second synth: timbre and rhythm
		SynthDef(\testcss2, {arg rthm = 0, timbre = 0, rtmrate=2; 
			var freq, amp, impulse, env, mul, ofreqs, oamps, efreqs, eamps, otimbre, etimbre, numbOTones;
			
			impulse = Impulse.ar(rtmrate, [0, rthm]); 
			env = Env.perc(0.05, 1/(rtmrate*2), 1, -4);
			mul = EnvGen.ar(env,impulse);
			otimbre = timbre.linlin(0,0.25,0,1).clip(0,1)*timbre.linlin(0.5,0.75,1,0).clip(0,1);
			etimbre = timbre.linlin(0.25,0.5,0,1).clip(0,1)*timbre.linlin(0.75,1,1,0).clip(0,1);
	
			freq = [440, 880]; amp = [1, 0.5];
			numbOTones = 30; 
			numbOTones.do{|i| // goes from first till 15th overtone
				if (i>1) {
					if (i.odd) 
						{ofreqs = ofreqs ++ (freq*i); oamps = oamps ++ (amp/i);} 
						{efreqs = efreqs ++ (freq*i); eamps = eamps ++ (amp/i);};
				};
			};
			efreqs.drop(1); eamps.drop(1); // first octave already there!
			oamps = oamps * otimbre;
			eamps = eamps * etimbre;
			
			Out.ar(0, (Mix.ar(SinOsc.ar((freq ++ ofreqs ++ efreqs),0, (amp*3 ++ oamps ++ eamps) * 0.01) * mul) )!2 );
		}).send(s);
	}
	

	shepardGUI {
	// GUI
		w = GUI.window.new("Vectors", Rect(750, 400, 420, 720));
		w.front;
		w.view.decorator = FlowLayout(w.view.bounds);
	
		b1 = SCButton.new(w,Rect(10,10,200,30));
		b1.states = [["PLAY: shepard and rhythm",Color.black, Color.new255(245, 245, 220)],
					["stop",Color.black, Color.new255(245, 245, 220)]];
		b1.action = {  arg butt;
			if(butt.value==1, {
				b11.valueAction_(0);
				css = Synth.new(\testcss1, [\b1, buf1.bufnum, \b2, buf2.bufnum]);
				css.set(\ph, pitchParam, \rthm, rthmParam, \rtmrate, rthmRate);
				}, 
				{css.free} )
			};	
	
		b11 = SCButton.new(w,Rect(10,10,200,30));
		b11.states = [["PLAY: timbre and rhythm",Color.black, Color.new255(245, 245, 220)],
					["stop",Color.black, Color.new255(245, 245, 220)]];
		b11.action = {  arg butt;
			if(butt.value==1, {
				b1.valueAction_(0);
				css = Synth.new(\testcss2);
				css.set(\timbre, timParam, \rthm, rthmParam, \rtmrate, rthmRate);
				}, 
				css.free; )
			};	w.view.decorator.nextLine;
	
		GUI.staticText.new(w, 200@15).string_("Dimension 1: (pitch parameter)");
		GUI.staticText.new(w, 200@15).string_("Dimension 2: (timbre parameter)");
		w.view.decorator.nextLine;
			
		t = SC2DSlider(w, Rect(20, 20, 200, 200))
			.x_(0.5)	// initial location of x
			.y_(0.5)	// initial location of y
			.action_({|sl|
				var angle, xcent, ycent;
				xcent = sl.x - 0.5;
				ycent = sl.y - 0.5;
				angle = ((atan((ycent.abs)/(xcent.abs))/1.5*90)).round(0.1);
				if(xcent>0 and:{ycent>0}) {pitchParam = (angle/360)}; 				if(xcent<0 and:{ycent>0}) {pitchParam = ((180 - angle)/360)}; 				if(xcent<0 and:{ycent<0}) {pitchParam = ((180 + angle)/360)}; 				if(xcent>0 and:{ycent<0}) {pitchParam = ((360 - angle)/360)}; 				css.set(\ph, pitchParam);
			});
		t.setProperty(\knobColor, Color.red);
				
		u = SC2DSlider(w, Rect(20, 20, 200, 200))
			.x_(0.5)	// initial location of x
			.y_(0.5)	// initial location of y
			.action_({|sl|
				var angle, xcent, ycent;
				xcent = sl.x - 0.5;
				ycent = sl.y - 0.5;
				angle = ((atan((ycent.abs)/(xcent.abs))/1.5*90)).round(0.1);
				if(xcent>0 and:{ycent>0}) {timParam = (angle/360)}; 				if(xcent<0 and:{ycent>0}) {timParam = ((180 - angle)/360)}; 				if(xcent<0 and:{ycent<0}) {timParam = ((180 + angle)/360)}; 				if(xcent>0 and:{ycent<0}) {timParam = ((360 - angle)/360)}; 				css.set(\timbre, timParam);
			});
		u.setProperty(\knobColor, Color.blue);
	
		w.view.decorator.nextLine;
		GUI.staticText.new(w, 300@15).string_("Dimension 3: (rhythm parameter)");
		w.view.decorator.nextLine;
			
		v = SC2DSlider(w, Rect(20, 20, 200, 200))
			.x_(0.5)	// initial location of x
			.y_(0.5)	// initial location of y
			.action_({|sl|
				var angle, xcent, ycent;
				xcent = sl.x - 0.5;
				ycent = sl.y - 0.5;
				angle = ((atan((ycent.abs)/(xcent.abs))/1.5*90)).round(0.1);
				if(xcent>0 and:{ycent>0}) {rthmParam = (angle/360)}; 				if(xcent<0 and:{ycent>0}) {rthmParam = ((180 - angle)/360)}; 				if(xcent<0 and:{ycent<0}) {rthmParam = ((180 + angle)/360)}; 				if(xcent>0 and:{ycent<0}) {rthmParam = ((360 - angle)/360)}; 				css.set(\rthm, rthmParam);
			});
		v.setProperty(\knobColor, Color.green);
			
		w.drawHook = {
			Pen.strokeColor = Color.red;			
			Pen.translate(5, 160); Pen.moveTo(0@0); Pen.lineTo(198@0);
			Pen.translate(100, -102); Pen.moveTo(0@0); Pen.lineTo(0@198);
			Pen.stroke;
	
			Pen.strokeColor = Color.blue;			
			Pen.translate(105, 102); Pen.moveTo(0@0); Pen.lineTo(198@0);
			Pen.translate(100, -102); Pen.moveTo(0@0); Pen.lineTo(0@198);
			Pen.stroke;
	
			Pen.strokeColor = Color.green;			
			Pen.translate(-305, 315); Pen.moveTo(0@0); Pen.lineTo(198@0);
			Pen.translate(100, -92); Pen.moveTo(0@0); Pen.lineTo(0@198);
			Pen.stroke;
		};
	
		GUI.staticText.new(w, 120@15).string_("Richtung aendern:");
	
		s2 = SCButton.new(w,Rect(10,10,80,20)); w.view.decorator.nextLine;
			s2.states = [["rechts",Color.black, Color.new255(245, 245, 245)], 
						["links",Color.black, Color.new255(245, 245, 245)]];
			s2.action = { arg butt; if (butt.value==1) {antiturn=0} {antiturn=1}};
	
		w.view.decorator.nextLine;
		w.view.decorator.nextLine;
		GUI.staticText.new(w, 300@15).string_("Verschiedene Szenarien:");
		w.view.decorator.nextLine;
	
		b2 = SCButton.new(w,Rect(10,10,200,20));
		b3 = SCButton.new(w,Rect(10,10,200,20)); w.view.decorator.nextLine;
		b4 = SCButton.new(w,Rect(10,10,404,20)); w.view.decorator.nextLine;
		b5 = SCButton.new(w,Rect(10,10,200,20)); 
		b6 = SCButton.new(w,Rect(10,10,200,20)); w.view.decorator.nextLine;
		w.view.decorator.nextLine;
	
		[b2, b3, b4, b5, b6].do{|item, i|
			item.states = [[alltasks[i][1],Color.black, Color.new255(245, 245, 220)], 
						["stop",Color.black, Color.new255(245, 245, 220)]];
			item.action = { arg butt; if (butt.value==1) 
				{[b2, b3, b4, b5, b6].do{|jtem, j| if (j != i) {jtem.valueAction_(0)}};
				alltasks[i][0].value; turner.play;} 
				{turner.stop}};
		};
		
		w.view.decorator.nextLine;
		w.view.decorator.nextLine;
		GUI.staticText.new(w, 280@15).string_("Parameter veraendern: ");
		w.view.decorator.nextLine;
		GUI.staticText.new(w, 280@15).string_("(die Illusion wird staerker oder geht verloren)");
		w.view.decorator.nextLine;
	
		s1 = EZSlider(	w,  	400@20,	"Sounds pro Umlauf",			[0, 100, \lin, 1].asSpec, {|ez| vortexNumb = ez.value }, vortexNumb, false, 150);
		w.view.decorator.nextLine;
		s3 = EZSlider(	w,  	400@20,	"Geschwindigkeit",			[1, 10, \lin, 1].asSpec, {|ez| rthmRate = ez.value }, rthmRate, false, 150);
		
		w.view.decorator.nextLine;
		b0 = SCButton.new(w,Rect(10,10,400,30)); w.view.decorator.nextLine;
		b0.states = [["Einstellungen zuruecksetzen",Color.black, Color.new255(245, 245, 245)]];
		b0.action = { vortexNumb = 50; rthmRate = 3; s1.value_(vortexNumb); s3.value_(rthmRate);
					css.set(\rtmrate, rthmRate);};
	
		SkipJack({ t.x = (cos(pitchParam*2pi)*0.5+0.5); t.y = (sin(pitchParam*2pi)*0.5+0.5) }, 0.025, { w.isClosed }, "windowRefresher");
		SkipJack({ u.x = (cos(timParam*2pi)*0.5+0.5); u.y = (sin(timParam*2pi)*0.5+0.5) }, 0.025, { w.isClosed }, "windowRefresher");
		SkipJack({ v.x = (cos(rthmParam*2pi)*0.5+0.5); v.y = (sin(rthmParam*2pi)*0.5+0.5) }, 0.025, { w.isClosed }, "windowRefresher");
	}
}