+ OSXPlatform {

	startupFiles {
//		var filename = "startup.rtf";
//		^[this.systemAppSupportDir +/+ filename, this.userAppSupportDir +/+ filename];
			// look for startup files inside the app Contents directory
		var filename = "startup.*";
		^(String.scDir +/+ filename).pathMatch;
	}

	startup {
		Document.implementationClass.startup;
		// make a server window for the internal if you like
		Server.internal.makeWindow;
//		Server.local.makeWindow;
		// uncomment if you use a startup file
//		this.loadStartupFiles;
		// uncomment if you have multiple help files
//		Help.addToMenu;
	}
}

+ Main {
	startup {
		var r, a;
		platform = this.platformClass.new;
		platform.initPlatform;

		super.startup;

		GUI.fromID( this.platform.defaultGUIScheme );
		GeneralHID.fromID( this.platform.defaultHIDScheme );

		// Set Server.default and the 's' interpreter variable to the internal server.
		// You should use the internal server for standalone applications --
		// otherwise, if your application has a problem, the user will
		// be stuck with a process, possibly making sound, that he won't know
		// how to kill.
		Server.default = Server.internal;
		interpreter.s = Server.default;

			// some folder paths that should point inside the app's Contents folder
		SynthDef.synthDefDir = String.scDir +/+ "synthdefs/";
		Archive.archiveDir = String.scDir;

		this.platform.startup;

		// from here on, you should customize what should happen...

		StartUp.run;

		// One can boot the server, then use .load to evaluate a file
		// OR - put things into a class... like the SCSA_Demo

		"Welcome to Standalone Demo made with SuperCollider, type cmd-d for help.".postln;

		Server.default.boot;

		Server.default.waitForBoot({
//			SCSA_Demo.new("The Cheese Stands Alone", Rect(400, 400, 300, 200), interpreter.s).front;
			(String.scDir.dirname ++ "/Resources/LoadXY.rtf").load;
		});
		// close post window if user should not have it
		Document.listener.close;
		
		r = Window.new("SpinQuartets",Rect(0,0,600,700));
		a = StaticText(r, Rect(10, 0, 580, 700));
		a.font = Font("Arial",12);
		a.align = \left;
		a.string = "Welcome to the SpinQuartets-Standalone!

This program simulates the XY-spin model, and plays an interactive sonification that allows to monitor acoustically the behavior of vortices and anti-vortices depending on the model temperature. The sonification is based on a distorted phase modulation of a base frequency.

Usage:
> run the model at different temperatures (or put it on hold)
> you can start by displaying where the vortices or anti-vortices are located, later only use the acoustical cue [which does not calculate the position but the sonification automatically brings them to the foreground]
> choose the neighborhood range of spin quartets (= 4 spins of a corner), thus how many quartets are played around the clicking point
> drag the spotlight to your point of interest
> all spin quartets within the spotlight play simultaneously, the vortices and anti-vortices are clearly audible and create a special beating timbre depending on their distances towards each other

Special features:
> the black box allows you to try out the sonification without visual cues
> the spiral path is an experimental extension of the spin quartets, it reaches farther and produces more complex sounds

More detailed information can be found at http://qcd-audio.at/results/xy and in the thesis \"Sonification of Simulations in Computational Physics\", K. Vogt, University of Music and Performing Arts Graz, Austria, 2010 (http://qcd-audio.at/publications/thesis_kv).

K. Vogt, D. Pirro\', R. Hoeldrich,
Project QCD-audio (funded by the FWF TRP-L519)";
		r.front;

	}

}
