/**
The (two-dimensional) XY MODEL:


 Metropolis-algorithm: compare hamiltonian of a new, random spin state with the old one,
 accept if rho >= random, where
 rho = exp( (q.coupling * (energyDeltaNew - energyDeltaOld)))
 
 krit bei 0.893 (?)

**/

	// constants and parameters
q.gridsize = 30;
q.coupling = 1;
q.magnetization = 0.0;
q.timeStep = 0.5;
q.epsilon = 0.3; // how far random new spin maximally is different from old spin
q.alpha = 0.05; // weight of old versus new averaged spin in smearing
q.coolingParam = 0; // if not 0: system is cooled
q.smearingParam = 0; // if not 0: system is smeared
q.data;

	// random number between 0 and 2pi 
q.randData = {|q| q.data = Array.fill2D(q.gridsize, q.gridsize, { 2pi.rand }); q.data; };

	// next frame
q.nextFrame = { |q|
	var allEnergy = 0;
	q.data.do { |line, lineIndex| q.data[lineIndex].do { |newSpin, colIndex|
		if (q.smearingParam == 0,
			{q.data[lineIndex][colIndex] = q.formula(q.energyDelta(lineIndex, colIndex));},
			{q.data[lineIndex][colIndex] = q.smearing(lineIndex, colIndex, q.alpha)});
	}};
	q.data;
};

	// next step, sets and returns a new frame
q.nextStep = {|q| q.data = q.nextFrame; q.data };

q.neighborsInModel = {|q, a, b|
	var neighbors, data = q.data, size = q.gridsize;
	neighbors = Array.fill(4, {0});
	neighbors = [
		data.at(a).wrapAt(b + 1), //	data[a][((b + 1).mod(size))],
		data.at(a).wrapAt(b - 1), //	data[a][((b - 1).mod(size))],
		data.wrapAt(a - 1).at(b), //	data[((a - 1).mod(size))][b],
		data.wrapAt(a + 1).at(b), //	data[((a + 1).mod(size))][b],
	];
	neighbors;
};
//q.neighborsInModel(2,2)
//q.data[2][3]

	// sum up the "kronecker deltas" of spins with all of the neighbours 
q.energyDelta = {|q, x, y|
	var data = q.data;
	var energyDeltaNew = 0, energyDeltaOld = 0, neighbors, energyDeltaNeigh = 0;
	
	q.oldSpin = data[x][y];
	q.newSpin = (data[x][y] + (q.epsilon * rrand(-1.0, 1.0))).mod(2pi);

	// calculate new energy depending on deltas with neighboring spins:
	neighbors = q.neighborsInModel(x, y);
	4.do {|i|
		energyDeltaNew = energyDeltaNew + (cos(q.newSpin - neighbors[i])); // if far apart - small deltaEnergy
		energyDeltaOld = energyDeltaOld + (cos(q.oldSpin - neighbors[i]));
	};
	energyDeltaNeigh = energyDeltaNew - energyDeltaOld; // ...pos>>oldEnergyDelta smaller
	// return the neighbors' energyDelta
	energyDeltaNeigh;
};

q.formula = {|q, energyDelta|
	var random, rho, data = q.data;

	random = rrand (0.0, 1.0);
	rho = (q.coupling * energyDelta); 

	if ( rho >= 0, { 	
		q.newSpin;
		}, { 
			if (q.coolingParam == 0, // without q.coolingParam != 0: cooling!
				{if ( random <= exp(rho), { q.newSpin;}, {q.oldSpin;};) },
				{ q.oldSpin });
	}); 
};

q.energy = {|q, c, d|
	var dphi1, dphi2, data = q.data, energy, size = q.gridsize;
	dphi1 = data[c][d] - data[c].wrapAt(d+1);
	dphi2 = data[c][d] - data.wrapAt(c+1)[d];
	energy = 2 - (cos(dphi1)) - (cos(dphi2));
	energy;
};
//q.energy(3, 4)
//q.neighborsInModel(3,3)[3]
	// next frame
q.calcEnergy = { |q|
	var allEnergy = 0;
	q.data.do { |line, lineIndex| q.data[lineIndex].do { |newSpin, colIndex|
		allEnergy = allEnergy + q.energy(lineIndex, colIndex);
	}};
	allEnergy = allEnergy / (2*q.gridsize.squared);
	q.allEnergy = allEnergy;
};

q.smearing = {|q, x, y, alpha| // destroys topology!!!
	var smearedSpin, thisSpin = q.data[x][y];
	smearedSpin = ((1-alpha) * thisSpin) + (alpha * q.neighborsInModel(x, y).sum / 4);
	smearedSpin = smearedSpin.mod(2pi);
	smearedSpin;
};

//	run the model
Tdef(\runModel, {
	inf.do{
		10.do{ 
			q.nextStep;
			q.updateWin;
			0.1.wait;
		if (q.vortShow == 1)
			{q.findVort; } {}; 

		};
		(q.gridsize.squared/10000;).wait; // thus larger models take more time for update
	};
	"Tdef runModel has finished!"	
});



/**

( // cool system and store energy and vortex development: 
// energy plateaus correspond to vortex/a.v.-annihilation
Tdef(\runCooling, {
	var numbRuns = 1000;
	var arrayEnergy = Array.fill(numbRuns, nil);
	var arrayVortices = Array.fill(numbRuns, nil);
	q.randData;
	q.updateWin;
	// equilibrate:
	q.smearingParam = 0; q.coolingParam = 0; //normal model
	100.do{q.nextStep; 0.01;};

	q.coolingParam = 1; q.smearingParam = 0; // do cooling!
	numbRuns.do{|i|
		q.nextStep;
		q.calcEnergy;
		arrayEnergy[i] = q.allEnergy;		
		arrayVortices[i] = q.findVort.size;		
	};
	q.updateWin;
	q.arrayEnergy = arrayEnergy;
	q.arrayVortices = arrayVortices;
	"Tdef runCooling has finished!".postln;	
}).play;
)
q.arrayEnergy.plot("Overall Energy")
q.arrayVortices.plot("Development of vortices")



//	make test data with sine shapes
q.makeTestData = { q.data = Array.fill2D(q.gridsize, q.gridsize, {|i, j| sin ((i*0.3)+j)});};
q.makeTestData; q.updateWin;

//  test mean magentization for different couplings

q.averageSpin = {|e|
	var meanxcomponent, meanycomponent;

	e.sindata = sin(q.data);
	e.cosdata = cos(q.data);
	
	meanycomponent = e.sindata.sum.sum/(q.gridsize.squared);
	meanxcomponent = e.cosdata.sum.sum/(q.gridsize.squared);

	[meanxcomponent, meanycomponent];
};

(
q.coupling = 0.01;
q.results = Array.fill2D(15, 2, 0);
10.do{ |k|
	a = Array.fill(200, 0);
	q.randData;
	200.do{ |i|
		10.do{ 
			q.nextStep;
			//q.updateWin;
			//0.1.wait;
		};
	a[i] = q.averageSpin;
	};
	q.results[k][0] = q.coupling;
	q.results[k][1] = a.mean;
	q.coupling = q.coupling + 0.1;
};
q.results.printAll;
)

(
var archive;
q.randData;
archive = ZArchive.write("~/Desktop/qranddata.scaz".standardizePath);
archive.writeItem(q.data);
archive.writeClose;
)

(
var archive;
archive = ZArchive.read("~/Desktop/qranddata.scaz".standardizePath);
c = archive.readItem;
)

// simple test random number generator with grain
// (allows to produce same list of "random" numbers)
q.aRand = pi - 3;
q.bRand = exp(1) - 2;
q.randGen = {|q|	
	r = (q.aRand+q.bRand).mod(1);
	q.aRand = q.bRand;
	q.bRand = r;
	2 * r - 1;
};
//q.randGen;

**/